/*
 * process_usage.c
 * This program demonstrates how to retrieve
 * process usage information.
 *
 * to compile:  cc -O -pipe print_limits.c  -o print_limits
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include <signal.h>

/* our declarations */
void show_usage();
void handler( int sig);

#define DISPLAY_FORMAT  ("%-20s | %10d\n")
#define MAX_CNT         (16384)
int main(int argc, char **argv)
{
    int i, j;
    double bar;
    char *foo;
    size_t len;

    /* Ignore some signals */
    signal( SIGHUP,  handler);
    signal( SIGILL,  handler);
    signal( SIGBUS,  handler);

    /* Show usage before we begin */
    show_usage();

    for(i = 0; i < MAX_CNT; i++)
    { 
	len = MAX_CNT * i;
	foo = (char *)malloc( len );
	if( foo )
	{
	    memset(foo, 8, len);

	    for(j = 0; j < len; j++)
	    {
		bar = (i * j) / (i * i) * ( j * j);
		foo[i] = (j % 8 );
	    }
	} /* if(foo) */

	if( (i % 128) == 0 )
	{
	    show_usage();
	    sleep(1);
	}

	free(foo);

    } /* for */



    /* FIN */
    return(0);
}

#define PAGE_TO_K(x)          ((getpagesize() * x) / 1024)
/*
 * show_usage
 * We simply have to print out the usage information.
 */
void show_usage()
{
    struct rusage usage;

    getrusage(RUSAGE_SELF, &usage);

    printf("Process information  PID[ %d ]\n", getpid());
    printf("-----------------------------------\n");
    printf(DISPLAY_FORMAT, "user time used", usage.ru_utime.tv_sec );
    printf(DISPLAY_FORMAT, "system time used", usage.ru_stime.tv_sec );
    printf(DISPLAY_FORMAT, "resident size", PAGE_TO_K(usage.ru_maxrss) );
    printf(DISPLAY_FORMAT, "shared memory size", usage.ru_ixrss );
    printf(DISPLAY_FORMAT, "unshared data ", usage.ru_idrss );
    printf(DISPLAY_FORMAT, "unshared stack", usage.ru_isrss);
    printf(DISPLAY_FORMAT, "page reclaims", usage.ru_minflt );
    printf(DISPLAY_FORMAT, "page faults", usage.ru_majflt );
    printf(DISPLAY_FORMAT, "swaps", usage.ru_nswap );
    printf(DISPLAY_FORMAT, "blocked input ops", usage.ru_inblock );
    printf(DISPLAY_FORMAT, "blocked output ops", usage.ru_oublock );
    printf(DISPLAY_FORMAT, "messages sent", usage.ru_msgsnd );
    printf(DISPLAY_FORMAT, "messages recieved", usage.ru_msgrcv );
    printf(DISPLAY_FORMAT, "signals recieved", usage.ru_nsignals );
    printf(DISPLAY_FORMAT, "voluntary context", usage.ru_nvcsw );
    printf(DISPLAY_FORMAT, "involuntary context", usage.ru_nivcsw );
    printf("-----------------------------------\n\n");
    
}

/*
 * handler
 * A very simple signal handler.
 */
void handler( int sig)
{
    printf("\nRecieved signal: %d\n", sig);
}
