/*
 * signal_alert.c
 * This program will demonstrate how to set a signal and then
 * how to send one. 
 *
 * to compile: gcc -O -pipe signal_alert.c -o signal_alert.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>

/* declare the signal handler */
void handler(int sig);


int main(int argc, char **argv)
{
	int sig;
	pid_t child;


	/* double-check our args */
	if( argc > 1 )
	{

		sig = atoi(argv[1]);

		child = fork();
		/* child */
		if( child == 0 )
		{
			/* set the signal handler */
			signal(sig, handler);

			/* sleep untill we get a signal */
			sleep(100000);
		}
		else
		{ /* parent */
			sleep(2);

			printf("Parent sending signal [ %d ] to PID [ %d ]\n", sig, child);
			kill(child, sig);
		}

	} /* if(argc) */


	/* FIN */
	return(0);
}

/*
 * handler
 * This function will analyze the signal sent to our
 * process
 */
void handler(int sig)
{
	pid_t pid;

	pid = getpid();

	printf("PID [ %d ] Recieved %d\n", pid, sig);

}
