/*
 * print_limits.c
 * This program demonstrates how to get and print
 * the system limits.
 *
 * to compile:  cc -O -pipe print_limits.c  -o print_limits
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

#define KILO(x)     (x / 1024)

int main(int argc, char **argv)
{
	int i;
	struct rlimit limits;


	/*
	 * Here we will obtain all of the limits. Note
	 * the RLIM_NLIMITS value, the maximum
	 * number of limits on the system. We
	 * suggest using that macro instead of a hard
	 * coded number, because it could change.
	 */
	for( i = 0; i < RLIM_NLIMITS; i++ )
	{
		getrlimit(i, &limits);

		/*
		 * Match up each value and print it out. The output is not
		 * very attractive, but serves its demonstration purpose.
		 */
		switch( i )
		{
			
			case RLIMIT_CPU:
				printf("RLIMIT_CPU\n\t Hard: %d \t Soft: %d\n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_FSIZE:
				printf("RLIMIT_FSIZE\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_DATA:
				printf("RLIMIT_DATA\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_STACK:
				printf("RLIMIT_STACK\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_CORE:
				printf("RLIMIT_CORE\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_RSS:
				printf("RLIMIT_RSS\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_NPROC:
				printf("RLIMIT_NPROC\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur);
				break;

			case RLIMIT_NOFILE:
				printf("RLIMIT_NOFILE\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur);
				break;

			case RLIMIT_MEMLOCK:
				printf("RLIMIT_MEMLOCK\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

			case RLIMIT_VMEM:
				printf("RLIMIT_VMEM\n\t Hard: %d \t Soft: %d \n", limits.rlim_max, limits.rlim_cur );
				break;

		} /* switch */

	} /* for */

	/* FIN */
	return(0);
}
