;
;        Copyright (c) 2005 AileronOS developers group
;        All rights reserved
;        See eula.txt for more information
;
;    File:
;
;        sysldr\fat32h.inc
;
;    Abstract:
;
;        FAT32 boot sector header
;
;    Created:
;
;        Vlad Maslakov, 2005
;

struc B {
 .none		rb 3

 .bsOemName	db "        " ; 0x03
 .BytsPerSec	dw ? ; 0x0B
 .SecPerClus	db ? ; 0x0D
 .RsvdSecCnt	dw ? ; 0x0E
 .NumFATs	db ? ; 0x10
 .RootEntCnt	dw ? ; 0x11
 .TotSec16	dw ? ; 0x13
 .Media		db ? ; 0x15
 .FATSz16	dw ? ; 0x16
 .SecPerTrk	dw ? ; 0x18
 .NumHeads	dw ? ; 0x1A
 .HiddSec	dd ? ; 0x1C
 .TotSec32	dd ? ; 0x20

 .FATSz32	dd ? ; 0x24
 .ExtFlags	dw ? ; 0x28
 .FSVer		dw ? ; 0x2A
 .RootClus	dd ? ; 0x2C
 .FSInfo	dw ? ; 0x30
 .BkBootSec	dw ? ; 0x32
 .Reserved	rb 12; 0x34

 .DrvNum	db ? ; 0x40
 .Reserved1	db ? ; 0x41
 .BootSig	db ? ; 0x42
 .VolID		rb 4 ; 0x43
 .VolLab	db "           " ; 0x47
 .FilSysType	db "FAT32   "    ; 0x52

 .FirstLogSec	dd ?
 .PrevFATSec	dd ?

 .A		dw ?
}

virtual at 0x7C00
 B B
end virtual
