/*++

Copyright (c) 2005 AileronOS developers group
All rights reserved

File:

    cdefs.h

Abstract:

    Standard types and macros definition

Author:

    16-Aug-2005       Vlad Maslakov

--*/

#ifndef _CDEFS_H_
#define _CDEFS_H_

//
// procedure attributes definition
//

#define STDCALL   __stdcall
#define CDECL     __cdecl
#define FASTCALL  __fastcall
#define NORETURN  __declspec(noreturn)
#define EXPORT    __declspec(dllexport)
#define IMPORT    __declspec(dllimport)

//
// boolean values definition
//

#define TRUE  (1==1)
#define FALSE (0==1)

//
// standard types definition
//

typedef char            CHAR;
typedef char            BOOL;
typedef char            BOOLEAN;
typedef char*           PCHAR;

typedef unsigned char   UCHAR;
typedef unsigned char*  PUCHAR;

typedef short           SHORT;
typedef unsigned short  USHORT;

typedef unsigned short  WORD;
typedef unsigned short* PWORD;

typedef int             INT;
typedef unsigned int    UINT;

typedef long            LONG;
typedef unsigned long   ULONG;

typedef unsigned long   DWORD;
typedef unsigned long*  PDWORD;

typedef long long           LONGLONG;
typedef unsigned long long  QWORD;
typedef unsigned long long* PQWORD;

typedef void*           PVOID;
typedef void*           LPVOID;

#endif //    _CDEFS_H_
